SWEP.AdminSpawnable = true
SWEP.ViewModelFOV = 90
SWEP.ViewModel = "models/weapons/v_pistk.mdl"
SWEP.WorldModel = "models/w_pistk.mdl"
SWEP.AutoSwitchTo = true
SWEP.Slot = 1
SWEP.HoldType = "pistol"
SWEP.PrintName = "Pistol"
SWEP.Author = ""
SWEP.Spawnable = true
SWEP.AutoSwitchfrom = true
SWEP.FiresUnderwater = true
SWEP.Weight = 5
SWEP.DrawCrosshair = false
SWEP.Category = "Kingpin"
SWEP.SlotPos = 2
SWEP.DrawAmmo = true
SWEP.ReloadSound = ("v_pistk/clip.wav")
SWEP.Instructions = ""
SWEP.Contact = ""
SWEP.Purpose = ""
SWEP.Base = "kingpin_base"

SWEP.BobScale	= 0.3
SWEP.SwayScale	= 0.1
if ( CLIENT ) then
SWEP.WepSelectIcon		= surface.GetTextureID( "vgui/h_pistol" )
	
	killicon.Add( "kingpin_pistol", "vgui/ah_pistol", Color( 255, 80, 0, 255 ) )
	end
	SWEP.mode = "default"

SWEP.Primary.Sound = (Sound("v_pistk/pistola1.wav"))
SWEP.Primary.Special1 = (Sound("v_pistk/silencer.wav"))
SWEP.Primary.Special2 = (Sound("v_pistk/silencerattatch.wav"))
SWEP.Primary.Reload = ("v_pistk/clip.wav")
SWEP.Primary.Damage = 25
SWEP.Primary.TakeAmmo = 1
SWEP.Primary.ClipSize = 10
SWEP.Primary.Ammo = "smg1"
SWEP.Primary.DefaultClip = 10
SWEP.Primary.Spread = 0.3
SWEP.Primary.NumberofShots = 1
SWEP.Primary.Automatic = true
SWEP.Primary.Recoil = 0.1
SWEP.Primary.Delay = 0.5
SWEP.Primary.Force = 4

SWEP.Secondary.Automatic = false
SWEP.Secondary.Delay = 2

function SWEP:Initialize()
	util.PrecacheSound("v_pistk/pistola2.wav")
	util.PrecacheSound("v_pistk/pistola3.wav")
	util.PrecacheSound("v_pistk/pistola4.wav")
	util.PrecacheSound("v_pistk/pistola1.wav")
	util.PrecacheSound("v_pistk/clip.wav")
	util.PrecacheSound("v_pistk/holster.wav")
	if ( SERVER ) then
		self:SetWeaponHoldType( self.HoldType )
	end
end

function SWEP:Deploy()
self.Weapon:SetNextPrimaryFire( CurTime() + 0.5 )
	   self.Weapon:SendWeaponAnim(ACT_VM_DRAW)
	   
self.Weapon:EmitSound(Sound("v_pistk/holster.wav"))
	   	   	if self.mode == "silenced" then
	self.Weapon:SetNextPrimaryFire( CurTime() + 0.5 )
	   self.Weapon:SendWeaponAnim(ACT_VM_DRAW_SILENCED)
	   
self.Weapon:EmitSound(Sound("v_pistk/holster.wav"))
        end
		end

function SWEP:Holster()
	self.Owner:SetNWBool("kpplysounds", false)
	return true
	end
		
function SWEP:PrimaryAttack()
	if not IsValid(self.Owner) or self.Owner:Health() < 0 or !self:CanPrimaryAttack() then return end
	local bullet = {}
		bullet.Num = self.Primary.NumberofShots
		bullet.Src = self.Owner:GetShootPos()
		bullet.Dir = self.Owner:GetAimVector()
		bullet.Spread = Vector( self.Primary.Spread * 0.1 , self.Primary.Spread * 0.1, 0)
		bullet.Tracer = 0
		bullet.Force = self.Primary.Force
		bullet.Damage = self.Primary.Damage
		bullet.AmmoType = self.Primary.Ammo
	local rnda = self.Primary.Recoil * -1
	local rndb = self.Primary.Recoil * math.random(-1, 1)
	self:ShootEffects()
	self.Owner:FireBullets( bullet )
 
	self.Owner:ViewPunch( Angle( rnda,rndb,rnda ) )
	self:TakePrimaryAmmo(self.Primary.TakeAmmo)
	self.Weapon:SetNextPrimaryFire( CurTime() + self.Primary.Delay )
	self.Weapon:SetNextSecondaryFire( CurTime() + .1 )
	if self.mode == "silenced" then
	self.Weapon:EmitSound(self.Primary.Special1)
	self.Weapon:SendWeaponAnim(ACT_VM_PRIMARYATTACK_1)
	else
if SERVER then self.Owner:EmitSound("v_pistk/pistola"..math.random(1,4)..".wav") end
		self:Muzzleflash()
	end
end
function SWEP:DryFire()
	self.Weapon:EmitSound("weapons/v_pipebar/noammo.wav")
end
function SWEP:SecondaryAttack()
self.Weapon:SetNextPrimaryFire( CurTime() + 2 )
self.Weapon:SetNextSecondaryFire( CurTime() + self.Secondary.Delay )
self.Weapon:EmitSound(self.Primary.Special2)
	if self.mode == "default" then
		self.mode = "silenced"
		self.Weapon:SendWeaponAnim(ACT_VM_ATTACH_SILENCER)
	elseif self.mode == "silenced" then
		self.mode = "default"
		self.Weapon:SendWeaponAnim(ACT_VM_DETACH_SILENCER)
	end
end
function SWEP:Muzzleflash()
	local pos = self.Owner:GetShootPos()
	local ang = self.Owner:GetAimVector():Angle()
	pos = pos +ang:Forward() *30 +ang:Right() *14 +ang:Up() *-6
	local effectdata = EffectData()
	effectdata:SetStart( pos )
	effectdata:SetOrigin( pos )
	util.Effect("kp_pistommuzz", effectdata)
end
function SWEP:Think()
self:Stuff()
end
function SWEP:Reload()
if ( self.Weapon:Ammo1() <= 0 ) then return end
	if ( self.Weapon:Clip1() >= self.Primary.ClipSize ) then return end
	self.Weapon:DefaultReload( ACT_VM_RELOAD )
	self:EmitSound( "v_pistk/clip.wav" )
	if self.mode == "silenced" then
	self.Weapon:SendWeaponAnim(ACT_VM_RELOAD_SILENCED)
	end
end